/**
 * \file: mlink_wfd_touch_internals.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * MLINK WiFi-Display Touch Adapter
 *
 * \component: mlink
 *
 * \author: V.Deety /RBEI/ECF3 / venkatasaiganesh.deety@in.bosch.com
 *
 * \copyright (c) 2016 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/

#ifndef MLINK_WFD_TOUCH_INTERNALS_H
#define MLINK_WFD_TOUCH_INTERNALS_H

#define VNC_USE_STDINT_H

#include <uspi/ITouchFacade.h>
#include <uspi/WaylandFacade.h>
#include <vncwifidisplaysdk.h>

#ifdef __cplusplus
extern "C" {
#endif

#define MLINK_WL_MAX_TOUCHPOINTS 2

using namespace adit::uspi;

typedef struct
{
        VNCWiFiDisplaySDK* pWFDSDK;
        VNCWiFiDisplaySink* pWFDSink;
        int touch_valid[MLINK_WL_MAX_TOUCHPOINTS];
        VNCTouchDescriptor touch_desc[MLINK_WL_MAX_TOUCHPOINTS];

}ml_wfd_touch_context;

class WfdTouch : public ITouchFacadeCallbacks
{
public:
        WfdTouch();
        ~WfdTouch();
        static WfdTouch* getInstance(void);
        static void deleteInstance(void);
        bool initialize(VNCWiFiDisplaySDK* pWFDSDK, VNCWiFiDisplaySink* pWFDSink, void* SessionCtx);
        void shutdown();

        // ITouchFacadeCallbacks
        void onTouch(TouchEvent inEvent);
        void onTouchError(int inError);
        void onLogging(UspiLogLevel inLogLevel, const std::string& inLogString);

private:
        static WfdTouch* gpSelf;
        std::unique_ptr<ITouchFacade> mTouchFacade;
        void send_touch(void);
        ml_wfd_touch_context* ctx;
};

#ifdef __cplusplus
}
#endif //__cplusplus

#endif
